<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('email_templates', function (Blueprint $table) {
            $table->unsignedBigInteger('language_id')->after('email_template_type');
            $table->foreign('language_id')->references('id')->on('languages')->onDelete('cascade');

            $table->unique(['email_template_type', 'language_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('email_templates', function (Blueprint $table) {
            $table->dropForeign(['language_id']);
            $table->dropUnique(['email_template_type', 'language_id']);
            $table->dropColumn('language_id');
        });
    }
};
